/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.fluids;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.capability.food.FoodData;
import net.dries007.tfc.api.capability.food.FoodStatsTFC;
import net.dries007.tfc.api.capability.food.IFoodStatsTFC;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.capability.player.IPlayerData;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.objects.fluids.properties.DrinkableProperty;
import net.dries007.tfc.objects.fluids.properties.FluidWrapper;
import net.dries007.tfc.objects.fluids.properties.MetalProperty;
import net.dries007.tfc.objects.potioneffects.PotionEffectsTFC;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.EnumRarity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public final class FluidsTFC {
    private static final ResourceLocation STILL = new ResourceLocation("tfc", "blocks/fluid_still");
    private static final ResourceLocation FLOW = new ResourceLocation("tfc", "blocks/fluid_flow");
    private static final HashBiMap<Fluid, FluidWrapper> WRAPPERS = HashBiMap.create();
    private static final ResourceLocation LAVA_STILL = new ResourceLocation("tfc", "blocks/lava_still");
    private static final ResourceLocation LAVA_FLOW = new ResourceLocation("tfc", "blocks/lava_flow");
    private static final Map<EnumDyeColor, FluidWrapper> DYE_FLUIDS = new EnumMap<EnumDyeColor, FluidWrapper>(EnumDyeColor.class);
    public static FluidWrapper HOT_WATER;
    public static FluidWrapper FRESH_WATER;
    public static FluidWrapper SALT_WATER;
    public static FluidWrapper LIMEWATER;
    public static FluidWrapper TANNIN;
    public static FluidWrapper VINEGAR;
    public static FluidWrapper BRINE;
    public static FluidWrapper MILK;
    public static FluidWrapper CURDLED_MILK;
    public static FluidWrapper MILK_VINEGAR;
    public static FluidWrapper OLIVE_OIL;
    public static FluidWrapper OLIVE_OIL_WATER;
    public static FluidWrapper LYE;
    public static FluidWrapper CIDER;
    public static FluidWrapper VODKA;
    public static FluidWrapper SAKE;
    public static FluidWrapper CORN_WHISKEY;
    public static FluidWrapper RYE_WHISKEY;
    public static FluidWrapper WHISKEY;
    public static FluidWrapper BEER;
    public static FluidWrapper RUM;
    private static ImmutableSet<FluidWrapper> allAlcoholsFluids;
    private static ImmutableMap<Metal, FluidWrapper> allMetalFluids;
    private static ImmutableSet<FluidWrapper> allOtherFiniteFluids;

    public static ImmutableSet<FluidWrapper> getAllAlcoholsFluids() {
        return allAlcoholsFluids;
    }

    public static ImmutableSet<FluidWrapper> getAllOtherFiniteFluids() {
        return allOtherFiniteFluids;
    }

    public static ImmutableCollection<FluidWrapper> getAllMetalFluids() {
        return allMetalFluids.values();
    }

    @Nonnull
    public static FluidWrapper getWrapper(@Nonnull Fluid fluid) {
        if (!WRAPPERS.containsKey((Object)fluid)) {
            WRAPPERS.put((Object)fluid, (Object)new FluidWrapper(fluid, false));
        }
        return (FluidWrapper)WRAPPERS.get((Object)fluid);
    }

    @Nonnull
    public static Set<FluidWrapper> getAllWrappers() {
        return WRAPPERS.values();
    }

    @Nonnull
    public static Fluid getFluidFromMetal(@Nonnull Metal metal) {
        return ((FluidWrapper)allMetalFluids.get((Object)metal)).get();
    }

    @Nonnull
    public static Metal getMetalFromFluid(@Nonnull Fluid fluid) {
        return FluidsTFC.getWrapper(fluid).get(MetalProperty.METAL).getMetal();
    }

    @Nonnull
    public static FluidWrapper getFluidFromDye(@Nonnull EnumDyeColor dyeColor) {
        return DYE_FLUIDS.get(dyeColor);
    }

    public static void registerFluids() {
        FRESH_WATER = FluidsTFC.registerFluid(new Fluid("fresh_water", STILL, FLOW, -14062899)).with(DrinkableProperty.DRINKABLE, player -> {
            if (player.func_71024_bL() instanceof FoodStatsTFC) {
                ((FoodStatsTFC)player.func_71024_bL()).addThirst(40.0f);
            }
        });
        HOT_WATER = FluidsTFC.registerFluid(new Fluid("hot_water", STILL, FLOW, -13344806).setTemperature(350));
        SALT_WATER = FluidsTFC.registerFluid(new Fluid("salt_water", STILL, FLOW, -14724967)).with(DrinkableProperty.DRINKABLE, player -> {
            if (player.func_71024_bL() instanceof FoodStatsTFC) {
                ((FoodStatsTFC)player.func_71024_bL()).addThirst(-10.0f);
                if (Constants.RNG.nextDouble() < ConfigTFC.General.PLAYER.chanceThirstOnSaltyDrink) {
                    player.func_70690_d(new PotionEffect(PotionEffectsTFC.THIRST, 600, 0));
                }
            }
        });
        DrinkableProperty alcoholProperty = player -> {
            IPlayerData playerData = (IPlayerData)player.getCapability(CapabilityPlayerData.CAPABILITY, null);
            if (player.func_71024_bL() instanceof FoodStatsTFC && playerData != null) {
                ((FoodStatsTFC)player.func_71024_bL()).addThirst(10.0f);
                playerData.addIntoxicatedTime(4000L);
                if (playerData.getIntoxicatedTime() > 24000L && Constants.RNG.nextFloat() < 0.5f) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 1200, 1));
                }
            }
        };
        allAlcoholsFluids = ImmutableSet.builder().add((Object[])new FluidWrapper[]{RUM = FluidsTFC.registerFluid(new Fluid("rum", STILL, FLOW, -9567965).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty), BEER = FluidsTFC.registerFluid(new Fluid("beer", STILL, FLOW, -3957193).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty), WHISKEY = FluidsTFC.registerFluid(new Fluid("whiskey", STILL, FLOW, -10995943).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty), RYE_WHISKEY = FluidsTFC.registerFluid(new Fluid("rye_whiskey", STILL, FLOW, -3703471).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty), CORN_WHISKEY = FluidsTFC.registerFluid(new Fluid("corn_whiskey", STILL, FLOW, -2504777).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty), SAKE = FluidsTFC.registerFluid(new Fluid("sake", STILL, FLOW, -4728388).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty), VODKA = FluidsTFC.registerFluid(new Fluid("vodka", STILL, FLOW, -2302756).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty), CIDER = FluidsTFC.registerFluid(new Fluid("cider", STILL, FLOW, -5198286).setRarity(EnumRarity.UNCOMMON)).with(DrinkableProperty.DRINKABLE, alcoholProperty)}).build();
        allOtherFiniteFluids = ImmutableSet.builder().add((Object[])new FluidWrapper[]{VINEGAR = FluidsTFC.registerFluid(new Fluid("vinegar", STILL, FLOW, -3685718)), BRINE = FluidsTFC.registerFluid(new Fluid("brine", STILL, FLOW, -2305079)), MILK = FluidsTFC.registerFluid(new Fluid("milk", STILL, FLOW, -1)).with(DrinkableProperty.DRINKABLE, player -> {
            if (player.func_71024_bL() instanceof IFoodStatsTFC) {
                IFoodStatsTFC foodStats = (IFoodStatsTFC)player.func_71024_bL();
                foodStats.addThirst(10.0f);
                foodStats.getNutrition().addBuff(FoodData.MILK);
            }
        }), OLIVE_OIL = FluidsTFC.registerFluid(new Fluid("olive_oil", STILL, FLOW, -9800393).setRarity(EnumRarity.RARE)), OLIVE_OIL_WATER = FluidsTFC.registerFluid(new Fluid("olive_oil_water", STILL, FLOW, -11909374)), TANNIN = FluidsTFC.registerFluid(new Fluid("tannin", STILL, FLOW, -10266290)), LIMEWATER = FluidsTFC.registerFluid(new Fluid("limewater", STILL, FLOW, -4934476)), CURDLED_MILK = FluidsTFC.registerFluid(new Fluid("milk_curdled", STILL, FLOW, -1048)), MILK_VINEGAR = FluidsTFC.registerFluid(new Fluid("milk_vinegar", STILL, FLOW, -1048)), LYE = FluidsTFC.registerFluid(new Fluid("lye", STILL, FLOW, -65570))}).build();
        allMetalFluids = ImmutableMap.builder().putAll(TFCRegistries.METALS.getValuesCollection().stream().collect(Collectors.toMap(metal -> metal, metal -> FluidsTFC.registerFluid(new Fluid(metal.getRegistryName().func_110623_a(), LAVA_STILL, LAVA_FLOW, metal.getColor())).with(MetalProperty.METAL, new MetalProperty((Metal)((Object)metal)))))).build();
        DYE_FLUIDS.putAll(Arrays.stream(EnumDyeColor.values()).collect(Collectors.toMap(color -> color, color -> {
            float[] c = color.func_193349_f();
            String actualName = color == EnumDyeColor.SILVER ? "light_gray" : color.func_176610_l();
            return FluidsTFC.registerFluid(new Fluid(actualName + "_dye", STILL, FLOW, new Color(c[0], c[1], c[2]).getRGB()));
        })));
    }

    @Nonnull
    private static FluidWrapper registerFluid(@Nonnull Fluid newFluid) {
        boolean isDefault;
        boolean bl = isDefault = !FluidRegistry.isFluidRegistered((String)newFluid.getName());
        if (!isDefault) {
            newFluid = FluidRegistry.getFluid((String)newFluid.getName());
        } else {
            FluidRegistry.registerFluid((Fluid)newFluid);
        }
        FluidRegistry.addBucketForFluid((Fluid)newFluid);
        FluidWrapper properties = new FluidWrapper(newFluid, isDefault);
        WRAPPERS.put((Object)newFluid, (Object)properties);
        return properties;
    }
}

